﻿using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace memoQSampleCMSConnector
{
    public class AvatarUrls
    {
        // Native JSON names were invalid C# identifiers since they started with a number.
        // In this case, we must set Json PropertyNames to allow deserialization.

        [JsonProperty(PropertyName = "48x48")]
        public string px48 { get; set; }
        [JsonProperty(PropertyName = "24x24")]
        public string px24 { get; set; }
        [JsonProperty(PropertyName = "16x16")]
        public string px16 { get; set; }
        [JsonProperty(PropertyName = "32x32")]
        public string px32 { get; set; }
    }

    public class Issue
    {
        public string expand { get; set; }
        public string id { get; set; }
        public string self { get; set; }
        public string key { get; set; }
    }

    public class IssueList
    {
        public string expand { get; set; }
        public int startAt { get; set; }
        public int maxResults { get; set; }
        public int total { get; set; }
        public List<Issue> issues { get; set; }

        internal void Add(IssueList issueList)
        {
            expand = issueList.expand;
            startAt = issueList.startAt;
            maxResults = issueList.maxResults;
            total = issueList.total;

            issues.AddRange(issueList.issues);
        }
    }

    public class issueListFull
    {
        public string expand { get; set; }
        public int startAt { get; set; }
        public int maxResults { get; set; }
        public int total { get; set; }
        public List<jiraIssue> issues { get; set; }

        internal void Add(issueListFull issueList)
        {
            expand = issueList.expand;
            startAt = issueList.startAt;
            maxResults = issueList.maxResults;
            total = issueList.total;

            issues.AddRange(issueList.issues);
        }
    }

    public class jiraIssue
    {
        public string expand { get; set; }
        public string id { get; set; }
        public string self { get; set; }
        public string key { get; set; }
        public Fields fields { get; set; }
    }

    public class Fields
    {
        public string summary { get; set; }
        public string description { get; set; }
        public string timespent { get; set; }
        public string aggregatetimespent { get; set; }
        public string timeoriginalestimate { get; set; }
        public string aggregatetimeoriginalestimate { get; set; }
        public string lastViewed { get; set; }
        public string created { get; set; }
        public string updated { get; set; }
        public string customfield_10002 { get; set; }
        public Obj10003 customfield_10003 { get; set; }
        public string customfield_10004 { get; set; }
        public string customfield_10005 { get; set; }
        public string customfield_10116 { get; set; }
        public string customfield_10704 { get; set; }
        public string customfield_10705 { get; set; }
        public string[] customfield_10400 { get; set; }
        public Source customfield_10702 { get; set; }
        public string[] customfield_10707 { get; set; }
        public string[] customfield_10900 { get; set; }
        public string[] customfield_10901 { get; set; }
        public string[] customfield_11100 { get; set; }

        public WorkLog worklog { get; set; }
        public IssueType issuetype { get; set; }
        public Project project { get; set; }
        public Status status { get; set; }
        public SubTask[] subtasks { get; set; }

        public TimeTracking timetracking { get; set; }
        public Assignee assignee { get; set; }
        public Comment comment { get; set; }
    }

    public class SubTask
    {
        public string id { get; set; }
        public string self { get; set; }
        public string key { get; set; }
        public SubTaskFields fields { get; set; }
    }

    public class SubTaskFields
    {
        public string summary { get; set; }
        public Status status { get; set; }
    }

    public class Status
    {
        public string name { get; set; }
    }

    public class Obj10003
    {
        public string value { get; set; }
    }

    public class Source
    {
        public string value { get; set; }
    }

    public class Project
    {
        public string key { get; set; }
        public string name { get; set; }
    }

    public class IssueType
    {
        public string name { get; set; }
    }

    public class WorkLog
    {
        public int startAt { get; set; }
        public int maxResults { get; set; }
        public int total { get; set; }
        public WorkLogs[] worklogs { get; set; }
    }

    public class WorkLogs
    {
        public string comment { get; set; }
        public string created { get; set; }
        public string updated { get; set; }
        public string started { get; set; }
        public string timeSpent { get; set; }
        public string timeSpentSeconds { get; set; }
        public Author author { get; set; }
        public UpdateAuthor updateAuthor { get; set; }
    }

    public class Author
    {
        public string name { get; set; }
        public string displayName { get; set; }
        public string emailAddress { get; set; }
    }

    public class UpdateAuthor
    {
        public string name { get; set; }
        public string displayName { get; set; }
        public string emailAddress { get; set; }
    }

    public class TimeTracking
    {
        public string remainingEstimate { get; set; }
        public string timeSpent { get; set; }
        public string timeSpentSeconds { get; set; }
    }

    public class Assignee
    {
        public string name { get; set; }
        public string emailAddress { get; set; }
        public string displayName { get; set; }
    }

    public class Comment
    {
        public int startAt { get; set; }
        public int maxResults { get; set; }
        public int total { get; set; }
        public List<CommentItem> comments { get; set; }
    }

    public class CommentItem
    {
        public string self { get; set; }
        public string id { get; set; }
        //public Author author { get; set; }
        public string body { get; set; }
        //public UpdateAuthor updateAuthor { get; set; }
        public string created { get; set; }
        public string updated { get; set; }
        public bool isTranslatableJA { get; set; }
        public bool isTranslatableEN { get; set; }
    }

    //public class JiraSearchResults
    //{
    //    public string startAt { get; set; }
    //    public string maxResults { get; set; }
    //    public string total { get; set; }
    //    public JiraIssue[] issues { get; set; }
    //}

    //public class SearchResult
    //{
    //    public string key { get; set; }
    //    public string project { get; set; }
    //    public string url { get; set; }
    //    public string summary { get; set; }
    //    public string description { get; set; }
    //}
    //public class JiraProject
    //{
    //    public string self { get; set; }
    //    public string id { get; set; }
    //    public string key { get; set; }
    //    public string name { get; set; }
    //    public AvatarUrls avatarUrls { get; set; }
    //}
    //public class JiraComponent
    //{
    //    public string id { get; set; }
    //    public string name { get; set; }
    //    public string project { get; set; }
    //    public string projectkey { get; set; }
    //    public string projectid { get; set; }
    //}
}